/*
 * Decompiled with CFR 0.152.
 */
package jace.tracker;

import jace.hardware.mockingboard.Card;
import jace.tracker.Pattern;
import jace.tracker.TrackerUI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Song {
    static final int CLOCK = 1789770;
    private List<Pattern> leftSequence;
    private List<Pattern> rightSequence;
    private String name;
    private String comments;
    private int tempo;

    public static Map<Card.Reg, Integer> translateRow(JTable table, int rowNumber) {
        HashMap<Card.Reg, Integer> row = new HashMap<Card.Reg, Integer>();
        Integer enable = Song.translateEnableFlags(table.getModel().getValueAt(rowNumber, 1));
        Integer noteA = Song.translateNote(table.getModel().getValueAt(rowNumber, 2));
        Integer ampA = Song.translateAmp(table.getModel().getValueAt(rowNumber, 3));
        Integer noteB = Song.translateNote(table.getModel().getValueAt(rowNumber, 4));
        Integer ampB = Song.translateAmp(table.getModel().getValueAt(rowNumber, 5));
        Integer noteC = Song.translateNote(table.getModel().getValueAt(rowNumber, 6));
        Integer ampC = Song.translateAmp(table.getModel().getValueAt(rowNumber, 7));
        DefaultCellEditor envEditor = (DefaultCellEditor)table.getCellEditor(rowNumber, 8);
        Integer envShape = Song.translateEnvShape(envEditor.getComponent());
        Integer envPer = Song.translateValue(table.getModel().getValueAt(rowNumber, 9));
        Integer noisePer = Song.translateValue(table.getModel().getValueAt(rowNumber, 10));
        if (enable != null) {
            row.put(Card.Reg.Enable, enable);
        }
        if (noteA != null) {
            row.put(Card.Reg.ACoarse, (noteA & 0xFF00) >> 8);
            row.put(Card.Reg.AFine, noteA & 0xFF);
        }
        if (noteB != null) {
            row.put(Card.Reg.BCoarse, (noteB & 0xFF00) >> 8);
            row.put(Card.Reg.BFine, noteB & 0xFF);
        }
        if (noteC != null) {
            row.put(Card.Reg.CCoarse, (noteC & 0xFF00) >> 8);
            row.put(Card.Reg.CFine, noteC & 0xFF);
        }
        if (ampA != null) {
            row.put(Card.Reg.AVol, ampA);
        }
        if (ampB != null) {
            row.put(Card.Reg.BVol, ampB);
        }
        if (ampC != null) {
            row.put(Card.Reg.CVol, ampC);
        }
        if (envPer != null) {
            row.put(Card.Reg.EnvCoarse, (envPer & 0xFF00) >> 8);
            row.put(Card.Reg.EnvFine, envPer & 0xFF);
        }
        if (envShape != null) {
            row.put(Card.Reg.EnvShape, envShape);
        }
        if (noisePer != null) {
            row.put(Card.Reg.NoisePeriod, noisePer);
        }
        return row;
    }

    private static Integer translateEnableFlags(Object flags) {
        if (flags == null) {
            return null;
        }
        String flagString = flags.toString().toLowerCase();
        if (flagString == "") {
            return null;
        }
        String[] flagStringParts = flagString.split(",");
        int enableValue = 255;
        if (flagStringParts.length > 0) {
            String enableChannel = flagStringParts[0];
            if (enableChannel.indexOf(97) > -1) {
                --enableValue;
            }
            if (enableChannel.indexOf(98) > -1) {
                enableValue -= 2;
            }
            if (enableChannel.indexOf(99) > -1) {
                enableValue -= 4;
            }
        }
        if (flagStringParts.length > 1) {
            String enableNoise = flagStringParts[1];
            if (enableNoise.indexOf(97) > -1) {
                enableValue -= 8;
            }
            if (enableNoise.indexOf(98) > -1) {
                enableValue -= 16;
            }
            if (enableNoise.indexOf(99) > -1) {
                enableValue -= 32;
            }
        }
        return enableValue;
    }

    private static Integer translateNote(Object noteValue) {
        if (noteValue == null) {
            return null;
        }
        if (noteValue instanceof Integer) {
            return (Integer)noteValue;
        }
        String noteValueStr = String.valueOf(noteValue);
        if (noteValueStr.equals("")) {
            return null;
        }
        Integer pitch = Song.translatePitch(noteValueStr);
        if (pitch != null) {
            return pitch;
        }
        return Song.translateNumber(noteValueStr);
    }

    private static Integer translateAmp(Object ampValue) {
        return Song.translateValue(ampValue);
    }

    private static Integer translateValue(Object objValue) {
        if (objValue == null) {
            return null;
        }
        if (objValue instanceof Integer) {
            return (Integer)objValue;
        }
        String noteValueStr = String.valueOf(objValue);
        if (noteValueStr.equals("")) {
            return null;
        }
        return Song.translateNumber(noteValueStr);
    }

    private static Integer translateEnvShape(Object objValue) {
        Integer val = null;
        if (objValue == null) {
            return null;
        }
        if (objValue instanceof JComboBox) {
            JComboBox combo = (JComboBox)objValue;
            val = combo.getSelectedIndex();
        } else {
            val = Song.translateValue(objValue);
        }
        if (val == null) {
            return null;
        }
        if (val >= 0 && val < TrackerUI.envelopeShapeValues.length) {
            return TrackerUI.envelopeShapeValues[val];
        }
        return null;
    }

    private static Integer translatePitch(String pitch) {
        try {
            if (pitch.length() < 2) {
                return null;
            }
            pitch = pitch.toLowerCase();
            Scale note = null;
            Integer octave = null;
            if (pitch.length() == 2) {
                note = Scale.valueOf(pitch.substring(0, 1));
                octave = Integer.valueOf(pitch.substring(1));
            } else if (pitch.length() == 3 && pitch.charAt(1) == '#') {
                note = Scale.valueOf(pitch.substring(0, 1) + "_sharp");
                octave = Integer.valueOf(pitch.substring(2));
            }
            if (note == null || octave == null) {
                return null;
            }
            double desiredPitch = note.pitch * Math.pow(2.0, octave - 1);
            return Song.generatePitchPeriod(desiredPitch, 1789770);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static int generatePitchPeriod(double desiredPitch, int clock) {
        double clockD = clock;
        int period = (int)(clockD / (desiredPitch * 16.0));
        return period;
    }

    private static Integer translateNumber(String num) {
        if ((num = num.toUpperCase()).startsWith("0X")) {
            try {
                return Integer.parseInt(num.substring(2), 16);
            }
            catch (NumberFormatException ex) {
            }
        } else if (num.startsWith("0")) {
            if ("0".equals(num)) {
                return new Integer(0);
            }
            try {
                return Integer.parseInt(num.substring(1), 8);
            }
            catch (NumberFormatException ex) {
            }
        } else {
            try {
                return Integer.parseInt(num);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public List<Pattern> getLeftSequence() {
        return this.leftSequence;
    }

    public void setLeftSequence(List<Pattern> leftSequence) {
        this.leftSequence = leftSequence;
    }

    public List<Pattern> getRightSequence() {
        return this.rightSequence;
    }

    public void setRightSequence(List<Pattern> rightSequence) {
        this.rightSequence = rightSequence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public int getTempo() {
        return this.tempo;
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scale {
        c(32.703, "c"),
        c_sharp(34.648, "c#"),
        d(36.708, "d"),
        d_sharp(38.891, "d#"),
        e(41.203, "e"),
        f(43.654, "f"),
        f_sharp(46.249, "f#"),
        g(48.999, "g"),
        g_sharp(51.913, "g#"),
        a(55.0, "a"),
        a_sharp(58.27, "a#"),
        b(61.735, "b");

        double pitch = 0.0;
        String display = "";

        private Scale(double _firstOctave, String _display) {
            this.pitch = _firstOctave;
            this.display = _display;
        }
    }
}

